// CDocDict.cp
// CDocDict.h
// ----------------------------------------------------------------------------------
// A Document dictionary class.
//
// This is a bloom based dictionary that acts a cache during spell checking.  When
// a user decides to 'ignore' a word it is placed in this dictonary.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Made the buffer into an abstract C++ class that was basically
//			an abstract datafile class.
// ----------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------
// Includes

//#define

#include "CDocDct.h"
#include <stdio.h>
#include <stdlib.h>
#include "UError.h"

// ----------------------------------------------------------------------------------
//	CDocDict		- Dictionary constructor
// ----------------------------------------------------------------------------------
// The constructor sets up the instance variables

CDocDict::CDocDict(long NumBuffers, FioParam * theFile)
	: CDict(NumBuffers, theFile)
{	
	// create a new bloom filter by the number of keys 
	DocFilter = new UBloom( NumBuffers, 18, By_Key );
	
	// error handling in UBloom already
	if  ( (ErrorFunc(0, GET)< eNo_Err) || (DocFilter == NULL))
	{	
		Usable = FALSE;
	} 
	
	Usable = TRUE;
	NumWords = 0;
	MaxWords = 0;
	
} // CDocDict

// ----------------------------------------------------------------------------------
//	~CDocDict		- Dictionary destructor
// ----------------------------------------------------------------------------------
// The destructor frees the memory

CDocDict::~CDocDict()
{
	if ( DocFilter != NULL )
		delete DocFilter;
} // ~CDocDict

// ----------------------------------------------------------------------------------
//	AddWord		- Add a word to the dictionary
// ----------------------------------------------------------------------------------
// This adds a word to a dictionary's bloom filter

short
CDocDict::Add( char *Word)
{
	// Can we use the dictionary?
	if ( Usable ) 
	{	
		// Is there room?
		if ( NumWords < MaxWords ) 
		{
			DocFilter->Insert( Word, strlen(Word) ); 
			NumWords++; 
		} else // clear the filter to avoid errors
		{
			DocFilter->Reset();
			DocFilter->Insert( Word, strlen(Word) );
			NumWords = 1;
		}
		return (OK);
	}
	ErrorFunc(eUnusableDict, SET);
	return (eUnusableDict);
} // AddWord

// ----------------------------------------------------------------------------------
//	CheckWord		- Add a word to the dictionary
// ----------------------------------------------------------------------------------
// This adds a word to a dictionary's bloom filter

short
CDocDict::Check( char *Word )
{
	// Is the Dictionary useable?
	if( Usable ) 
	{
		if( DocFilter->Test( Word, strlen(Word) ) == FOUND) 
			return FOUND;
		return NOTFOUND;
	}
	ErrorFunc(eUnusableDict, SET);
	return (eUnusableDict);

} // CheckWord



